<?xml version="1.0" encoding="iso-8859-1"?>
<!--*************************************************************************-->
<!--                                                                         -->
<!-- XSLT Visual Studio exporter                                             -->
<!-- Borland Developer Studio                                                -->
<!--                                                                         -->
<!-- Copyright (c) 2003 Borland Software Corporation                         -->
<!--                                                                         -->
<!--*************************************************************************-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- This has to to stay in text mode. Otherwise, my &lt type symbols come -->
<!--   out wrong. XML mode adds a header it can't support which prevents -->
<!--   proper processing. Html doesn't hanlde the & correctly either. -->
<xsl:output method="text" encoding="iso-8859-1" indent="yes"/>

<!-- Adds the XML version header. It must be right up against the template -->
<!-- tag or the post processor complains. -->
<xsl:template match="/">&lt;?xml version="1.0"?&gt;
	<xsl:apply-templates/>
</xsl:template>

<!-- This template creates the root node and begins the processing. -->
<xsl:template match="BorlandProject">
	&lt;VisualStudioProject&gt;
	<xsl:apply-templates/>
	&lt;/VisualStudioProject&gt;
</xsl:template>

<!-- SKIP BORLAND PersonalityInfo, we'll pump that information later -->
<xsl:template match="PersonalityInfo"/>

<!-- Borland CSharp.Personality -->
<xsl:template match="CSharp.Personality">
	<!-- Create CSHARP Microsoft personality -->
	&lt;CSHARP
	<xsl:choose>
	<xsl:when test="/BorlandProject/PersonalityInfo/Option/Option[./@Name='ProjectType']='AspProject'">
	ProjectType = "Web"
	</xsl:when>
	<xsl:otherwise>
	ProjectType = "Local"
	</xsl:otherwise>
	</xsl:choose>
	ProductVersion = "7.10.3052"
	SchemaVersion="2.0"
	ProjectGuid="<xsl:value-of select="/BorlandProject/PersonalityInfo/Option/Option[./@Name='GUID']"/>"
	&gt;
	&lt;Build&gt;
	<!-- <xsl:apply-templates/> -->
	<xsl:call-template name="CSharp.Options"/>
	<xsl:call-template name="References"/>
	&lt;/Build&gt;
	<xsl:call-template name="Filelist"/>
	&lt;/CSHARP&gt;
</xsl:template>

<!-- CSharp.Options -->
<xsl:template name="CSharp.Options">
	<xsl:variable name="CSharpProjectOption" select="/BorlandProject/ImportData/CSharpProjectOptions"/>
	<xsl:variable name="FirstOptionSet" select="/BorlandProject/CSharp.Personality/Options/OptionsSet[1]/Options/Options"/>

	&lt;Settings
	<xsl:choose>
	<!-- Is there imported project data we can use -->
	<xsl:when test="$CSharpProjectOption">
	ApplicationIcon = "<xsl:value-of select="$FirstOptionSet[@Name='ApplicationIcon']"/>"
	AssemblyKeyContainerName = "<xsl:value-of select="$CSharpProjectOption/@AssemblyKeyContainerName"/>"
	AssemblyName = "<xsl:value-of select="$FirstOptionSet[@Name='TargetName']"/>"
	AssemblyOriginatorKeyFile = "<xsl:value-of select="$CSharpProjectOption/@AssemblyOriginatorKeyFile"/>"
	DefaultClientScript = "<xsl:value-of select="$CSharpProjectOption/@DefaultClientScript"/>"
	DefaultHTMLPageLayout = "<xsl:value-of select="$CSharpProjectOption/@DefaultHTMLPageLayout"/>"
	DefaultTargetSchema = "<xsl:value-of select="$CSharpProjectOption/@DefaultTargetSchema"/>"
	DelaySign = "<xsl:value-of select="$CSharpProjectOption/@DelaySign"/>"
	PreBuildEvent = "<xsl:value-of select="$CSharpProjectOption/@PreBuildEvent"/>"
	PostBuildEvent = "<xsl:value-of select="$CSharpProjectOption/@PostBuildEvent"/>"
	RunPostBuildEvent = "<xsl:value-of select="$CSharpProjectOption/@RunPostBuildEvent"/>"
	<xsl:choose> <xsl:when test="$FirstOptionSet[@Name='TargetType']='Windows'">
	OutputType = "WinExe"
	</xsl:when> <xsl:when test="string($FirstOptionSet[@Name='TargetType'])='Console'">
	OutputType = "Exe"
	</xsl:when> <xsl:when test="string($FirstOptionSet[@Name='TargetType'])='Assembly'">
	OutputType = "Library"
	</xsl:when> <xsl:otherwise>
	OutputType = ""
	</xsl:otherwise> </xsl:choose>
	RootNamespace = "<xsl:value-of select="$FirstOptionSet[@Name='DefaultNamespace']"/>"
	StartupObject = "<xsl:value-of select="$FirstOptionSet[@Name='Main']"/>"
	</xsl:when>
	<xsl:otherwise>
	ApplicationIcon = "<xsl:value-of select="$FirstOptionSet[@Name='ApplicationIcon']"/>"
	AssemblyKeyContainerName = ""
	AssemblyName = "<xsl:value-of select="$FirstOptionSet[@Name='TargetName']"/>"
	AssemblyOriginatorKeyFile = ""
	DefaultClientScript = "JScript"
	DefaultHTMLPageLayout = "Grid"
	DefaultTargetSchema = "IE50"
	DelaySign = "false"
	PreBuildEvent = ""
	PostBuildEvent = ""
	RunPostBuildEvent = ""
	<xsl:choose> <xsl:when test="$FirstOptionSet[@Name='TargetType']='Windows'">
	OutputType = "WinExe"
	</xsl:when> <xsl:when test="string($FirstOptionSet[@Name='TargetType'])='Console'">
	OutputType = "Exe"
	</xsl:when> <xsl:when test="string($FirstOptionSet[@Name='TargetType'])='Assembly'">
	OutputType = "Library"
	</xsl:when> <xsl:otherwise>
	OutputType = ""
	</xsl:otherwise> </xsl:choose>
	RootNamespace = "<xsl:value-of select="$FirstOptionSet[@Name='DefaultNamespace']"/>"
	StartupObject = "<xsl:value-of select="$FirstOptionSet[@Name='Main']"/>"
	</xsl:otherwise>
	</xsl:choose>
	&gt;

	<xsl:call-template name="CSharp.Options.Config"/>
	&lt;/Settings&gt;
</xsl:template>

<!-- CSharp.Options.Config -->
<xsl:template name="CSharp.Options.Config">
	<xsl:variable name="CSharpLocalOptions" select="/BorlandProject/ImportData/CSharpLocalOptions"/>
	<xsl:variable name="OptionSet" select="/BorlandProject/CSharp.Personality/Options/OptionsSet"/>

	<xsl:for-each select="$OptionSet/*">
	<xsl:variable name="OptionsName"><xsl:value-of select="../@Name"/></xsl:variable>
	&lt;Config
	<xsl:choose>
	<xsl:when test="$CSharpLocalOptions/@Name=$OptionsName">
	<xsl:variable name="LocalOptions" select="$CSharpLocalOptions[@Name=$OptionsName]"/>
	Name = "<xsl:value-of select="../@Name"/>"
	AllowUnsafeBlocks = "<xsl:value-of select="./Options[@Name='ivUnsafe']"/>"
	BaseAddress = "<xsl:value-of select="./Options[@Name='BaseAddress']"/>"
	CheckForOverflowUnderflow = "<xsl:value-of select="./Options[@Name='Overflow']"/>"
	ConfigurationOverrideFile = "<xsl:value-of select="$LocalOptions/@ConfigurationOverrideFile"/>"
	DefineConstants = "<xsl:value-of select="./Options[@Name='Defines']"/>"
	DocumentationFile = "<xsl:value-of select="./Options[@Name='DocumentationFile']"/>"
	DefineDebug = "<xsl:value-of select="$LocalOptions/@DefineDebug"/>"
	DebugSymbols = "<xsl:value-of select="./Options[@Name='DebugInformation']"/>"
	FileAlignment = "<xsl:value-of select="$LocalOptions/@FileAlignment"/>"
	IncrementalBuild = "<xsl:value-of select="./Options[@Name='Incremental']"/>"
	NoStdLib = "<xsl:value-of select="$LocalOptions/@NoStdLib"/>"
	NoWarn = "<xsl:value-of select="$LocalOptions/@NoWarn"/>"
	Optimize = "<xsl:value-of select="./Options[@Name='Optimization']"/>"
	OutputPath = "<xsl:value-of select="./Options[@Name='OutputDirectory']"/>"
	RegisterForComInterop = "<xsl:value-of select="$LocalOptions/@RegisterForComInterop"/>"
	RemoveIntegerChecks = "<xsl:value-of select="$LocalOptions/@RemoveIntegerChecks"/>"
	TreatWarningsAsErrors = "<xsl:value-of select="./Options[@Name='WarningAsError']"/>"
	WarningLevel = "<xsl:value-of select="./Options[@Name='Warning']"/>"
	</xsl:when>
	<xsl:otherwise>
	Name = "<xsl:value-of select="../@Name"/>"
	AllowUnsafeBlocks = "<xsl:value-of select="./Options[@Name='ivUnsafe']"/>"
	BaseAddress = "<xsl:value-of select="./Options[@Name='BaseAddress']"/>"
	CheckForOverflowUnderflow = "<xsl:value-of select="./Options[@Name='Overflow']"/>"
	ConfigurationOverrideFile = ""
	DefineConstants = "<xsl:value-of select="./Options[@Name='Defines']"/>"
	DocumentationFile = "<xsl:value-of select="./Options[@Name='DocumentationFile']"/>"
	DefineDebug = "false"
	DebugSymbols = "<xsl:value-of select="./Options[@Name='DebugInformation']"/>"
	FileAlignment = "4096"
	IncrementalBuild = "<xsl:value-of select="./Options[@Name='Incremental']"/>"
	NoStdLib = "false"
	NoWarn = ""
	Optimize = "<xsl:value-of select="./Options[@Name='Optimization']"/>"
	OutputPath = "<xsl:value-of select="./Options[@Name='OutputDirectory']"/>"
	RegisterForComInterop = "false"
	RemoveIntegerChecks = "false"
	TreatWarningsAsErrors = "<xsl:value-of select="./Options[@Name='WarningAsError']"/>"
	WarningLevel = "<xsl:value-of select="./Options[@Name='Warning']"/>"
	</xsl:otherwise>
	</xsl:choose>
	/&gt;
	</xsl:for-each>
</xsl:template>

<!-- Borland VB.Personality -->
<xsl:template match="VB.Personality">
	<!-- Use this to create all of the  VisualBasic Microsoft personality -->
	<xsl:variable name="VisualBasicProject" select="/BorlandProject/ImportData/VisualBasicProjectData"/>

	<!-- Create VisualBasic Microsoft personality -->
	&lt;VisualBasic
	<xsl:choose>
	<xsl:when test="/BorlandProject/PersonalityInfo/Option/Option[./@Name='ProjectType']='AspProject'">
	ProjectType = "Web"
	</xsl:when>
	<xsl:otherwise>
	ProjectType = "Local"
	</xsl:otherwise>
	</xsl:choose>
	ProductVersion = "7.10.3052"
	SchemaVersion="2.0"
	ProjectGuid="<xsl:value-of select="/BorlandProject/PersonalityInfo/Option/Option[./@Name='GUID']"/>"
	&gt;
	&lt;Build&gt;
	<!-- <xsl:apply-templates/> -->
	<xsl:call-template name="VisualBasic.Options"/>
	<xsl:call-template name="References"/>
	&lt;/Build&gt;
	<xsl:call-template name="Filelist"/>
	&lt;/VisualBasic&gt;
</xsl:template>

<!-- VisualBasic.Options -->
<xsl:template name="VisualBasic.Options">
	<xsl:variable name="VisualBasicProjectOptions" select="/BorlandProject/ImportData/VisualBasicProjectOptions"/>
	<xsl:variable name="FirstOptionSet" select="/BorlandProject/VB.Personality/Options/OptionsSet[1]/Options/Options"/>

	&lt;Settings
	<xsl:choose>
	<!-- Is there imported project data we can use -->
	<xsl:when test="$VisualBasicProjectOptions">
	ApplicationIcon = "<xsl:value-of select="$FirstOptionSet[@Name='ApplicationIcon']"/>"
	AssemblyKeyContainerName = "<xsl:value-of select="$VisualBasicProjectOptions/@AssemblyKeyContainerName"/>"
	AssemblyName = "<xsl:value-of select="$FirstOptionSet[@Name='TargetName']"/>"
	AssemblyOriginatorKeyFile = "<xsl:value-of select="$VisualBasicProjectOptions/@AssemblyOriginatorKeyFile"/>"
	DefaultClientScript = "<xsl:value-of select="$VisualBasicProjectOptions/@DefaultClientScript"/>"
	DefaultHTMLPageLayout = "<xsl:value-of select="$VisualBasicProjectOptions/@DefaultHTMLPageLayout"/>"
	DefaultTargetSchema = "<xsl:value-of select="$VisualBasicProjectOptions/@DefaultTargetSchema"/>"
	DelaySign = "<xsl:value-of select="$VisualBasicProjectOptions/@DelaySign"/>"
	<xsl:choose> <xsl:when test="$FirstOptionSet[@Name='TargetType']='Windows'">
	OutputType = "WinExe"
	</xsl:when> <xsl:when test="string($FirstOptionSet[@Name='TargetType'])='Console'">
	OutputType = "Exe"
	</xsl:when> <xsl:when test="string($FirstOptionSet[@Name='TargetType'])='Assembly'">
	OutputType = "Library"
	</xsl:when> <xsl:otherwise>
	OutputType = ""
	</xsl:otherwise> </xsl:choose>
	OptionCompare = "<xsl:value-of select="$VisualBasicProjectOptions/@OptionCompare"/>"
	OptionExplicit = "<xsl:value-of select="$VisualBasicProjectOptions/@OptionExplicit"/>"
	OptionStrict = "<xsl:value-of select="$VisualBasicProjectOptions/@OptionStrict"/>"
	RootNamespace = "<xsl:value-of select="$FirstOptionSet[@Name='DefaultNamespace']"/>"
	StartupObject = "<xsl:value-of select="$FirstOptionSet[@Name='DefaultNamespace']"/>.<xsl:value-of select="$FirstOptionSet[@Name='Main']"/>"
	</xsl:when>
	<xsl:otherwise>
	ApplicationIcon = "<xsl:value-of select="$FirstOptionSet[@Name='ApplicationIcon']"/>"
	AssemblyKeyContainerName = ""
	AssemblyName = "<xsl:value-of select="$FirstOptionSet[@Name='TargetName']"/>"
	AssemblyOriginatorKeyFile = ""
	DefaultClientScript = "JScript"
	DefaultHTMLPageLayout = "Grid"
	DefaultTargetSchema = "IE50"
	DelaySign = "false"
	<xsl:choose> <xsl:when test="$FirstOptionSet[@Name='TargetType']='Windows'">
	OutputType = "WinExe"
	</xsl:when> <xsl:when test="string($FirstOptionSet[@Name='TargetType'])='Console'">
	OutputType = "Exe"
	</xsl:when> <xsl:when test="string($FirstOptionSet[@Name='TargetType'])='Assembly'">
	OutputType = "Library"
	</xsl:when> <xsl:otherwise>
	OutputType = ""
	</xsl:otherwise> </xsl:choose>
	OptionCompare = "Binary"
	OptionExplicit = "On"
	OptionStrict = "Off"
	RootNamespace = "<xsl:value-of select="$FirstOptionSet[@Name='DefaultNamespace']"/>"
	StartupObject = "<xsl:value-of select="$FirstOptionSet[@Name='DefaultNamespace']"/>.<xsl:value-of select="$FirstOptionSet[@Name='Main']"/>"
	</xsl:otherwise>
	</xsl:choose>
	&gt;

	<xsl:call-template name="VisualBasic.Options.Config"/>
	&lt;/Settings&gt;
</xsl:template>

<!-- VisualBasic.Options.Config -->
<xsl:template name="VisualBasic.Options.Config">
	<xsl:variable name="VisualBasicLocalOptions" select="/BorlandProject/ImportData/VisualBasicLocalOptions"/>
	<xsl:variable name="OptionSet" select="/BorlandProject/VB.Personality/Options/OptionsSet"/>

	<xsl:for-each select="$OptionSet/*">
	<xsl:variable name="OptionsName"><xsl:value-of select="../@Name"/></xsl:variable>
	&lt;Config
	<xsl:choose>
	<xsl:when test="$VisualBasicLocalOptions/@Name=$OptionsName">
	<xsl:variable name="LocalOptions" select="$VisualBasicLocalOptions[@Name=$OptionsName]"/>
	Name = "<xsl:value-of select="../@Name"/>"
	AllowUnsafeBlocks = "<xsl:value-of select="./Options[@Name='ivUnsafe']"/>"
	BaseAddress = "<xsl:value-of select="./Options[@Name='BaseAddress']"/>"
	CheckForOverflowUnderflow = "<xsl:value-of select="./Options[@Name='Overflow']"/>"
	ConfigurationOverrideFile = "<xsl:value-of select="$LocalOptions/@ConfigurationOverrideFile"/>"
	DefineConstants = "<xsl:value-of select="./Options[@Name='Defines']"/>"
	DocumentationFile = "<xsl:value-of select="./Options[@Name='DocumentationFile']"/>"
	DefineDebug = "<xsl:value-of select="$LocalOptions/@DefineDebug"/>"
	DefineTrace = "<xsl:value-of select="$LocalOptions/@DefineTrace"/>"
	DebugSymbols = "<xsl:value-of select="./Options[@Name='DebugInformation']"/>"
	IncrementalBuild = "<xsl:value-of select="./Options[@Name='Incremental']"/>"
	NoStdLib = "<xsl:value-of select="$LocalOptions/@NoStdLib"/>"
	NoWarn = "<xsl:value-of select="$LocalOptions/@NoWarn"/>"
	Optimize = "<xsl:value-of select="./Options[@Name='Optimization']"/>"
	OutputPath = "<xsl:value-of select="./Options[@Name='OutputDirectory']"/>"
	RegisterForComInterop = "<xsl:value-of select="$LocalOptions/@RegisterForComInterop"/>"
	RemoveIntegerChecks = "<xsl:value-of select="$LocalOptions/@RemoveIntegerChecks"/>"
	TreatWarningsAsErrors = "<xsl:value-of select="./Options[@Name='WarningAsError']"/>"
	WarningLevel = "<xsl:value-of select="./Options[@Name='Warning']"/>"
	</xsl:when>
	<xsl:otherwise>
	Name = "<xsl:value-of select="../@Name"/>"
	AllowUnsafeBlocks = "<xsl:value-of select="./Options[@Name='ivUnsafe']"/>"
	BaseAddress = "<xsl:value-of select="./Options[@Name='BaseAddress']"/>"
	CheckForOverflowUnderflow = "<xsl:value-of select="./Options[@Name='Overflow']"/>"
	ConfigurationOverrideFile = ""
	DefineConstants = "<xsl:value-of select="./Options[@Name='Defines']"/>"
	DocumentationFile = "<xsl:value-of select="./Options[@Name='DocumentationFile']"/>"
	DefineDebug = "false"
	DefineTrace = "false"
	DebugSymbols = "<xsl:value-of select="./Options[@Name='DebugInformation']"/>"
	IncrementalBuild = "<xsl:value-of select="./Options[@Name='Incremental']"/>"
	NoStdLib = "false"
	NoWarn = ""
	Optimize = "<xsl:value-of select="./Options[@Name='Optimization']"/>"
	OutputPath = "<xsl:value-of select="./Options[@Name='OutputDirectory']"/>"
	RegisterForComInterop = "false"
	RemoveIntegerChecks = "false"
	TreatWarningsAsErrors = "<xsl:value-of select="./Options[@Name='WarningAsError']"/>"
	WarningLevel = "<xsl:value-of select="./Options[@Name='Warning']"/>"
	</xsl:otherwise>
	</xsl:choose>
	/&gt;
	</xsl:for-each>
</xsl:template>

<!-- Filelist -->
<xsl:template name="Filelist">
	&lt;Files&gt;
	&lt;Include&gt;
	<xsl:for-each select="/BorlandProject/CSharp.Personality/FileList/File[not(./@ContainerId='DotNetAssemblyCompiler')] | /BorlandProject/VB.Personality/FileList/File[not(./@ContainerId='DotNetAssemblyCompiler')]">
	<xsl:variable name="ParentNode"><xsl:if test="@Parent and not(@ContainerId='WebRefCreator')">DependentUpon = "<xsl:call-template name="StripPath"><xsl:with-param name="Module" select="@Parent"/></xsl:call-template>"</xsl:if></xsl:variable>
	<xsl:if test='not(@WebReferenceUrl)'>&lt;File</xsl:if>
	<xsl:if test='@WebReferenceUrl'>&lt;Folder</xsl:if>
	RelPath = "<xsl:value-of select="@FileName"/>"
	<xsl:choose>
	<xsl:when test="@ContainerId='CSharpCompiler' or @ContainerId='VBTool'">
	BuildAction = "Compile"
	<xsl:if test="@FileTypeString='System.Windows.Forms.Form'">
	SubType = "Form"
	</xsl:if>
	<xsl:if test="@FileTypeString='System.Web.HttpApplication'">
	SubType = "Code"
	</xsl:if>
	<xsl:if test="@FileTypeString='System.Web.UI.Page'">
	SubType = "ASPXCodeBehind"
	</xsl:if>
	</xsl:when>
	<xsl:when test="@ContainerId='ResXCompiler'">
	BuildAction = "EmbeddedResource"
	</xsl:when>
	<xsl:when test="@ContainerId='AspMarkupContainer'">
	<xsl:choose>
	<xsl:when test="contains(@FileName, '.aspx')">
	SubType = "Form"
	</xsl:when>
	<xsl:when test="contains(@FileName, '.asax')">
	SubType = "Component"
	</xsl:when>
	</xsl:choose>
	BuildAction = "Content"
	</xsl:when>
	<xsl:when test="@BuildAction='Content'">
	BuildAction = "Content"
	</xsl:when>
	<xsl:when test="@ContainerId='WebRefCreator'">
	<xsl:variable name="WebParentNode"><xsl:if test="@Parent">DependentUpon = "<xsl:value-of select="@Parent"/>"</xsl:if></xsl:variable>
	<xsl:choose>
	<xsl:when test='@WebReferenceUrl'>
	WebReferenceUrl = "<xsl:value-of select="@WebReferenceUrl"/>"
	UrlBehavior = "Static"
	</xsl:when>
	<xsl:when test='@CustomToolNamespace'>
	BuildAction = "None"
	Generator = "MSDiscoCodeGenerator"
	</xsl:when>
	<xsl:otherwise>
	BuildAction = "None"
	</xsl:otherwise>
	</xsl:choose>
	</xsl:when>
	<xsl:otherwise>
	BuildAction = "Content"
	</xsl:otherwise>
	</xsl:choose>
	<xsl:value-of select="$ParentNode"/>
	/&gt;
	</xsl:for-each>

	<!-- All we need to know is if there is one web reference. If so, we need to create a "TRUE" web ref pointer -->
	<xsl:if test="/BorlandProject/CSharp.Personality/FileList/File[./@WebReferenceUrl] or /BorlandProject/VB.Personality/FileList/File[./@WebReferenceUrl]">
	&lt;Folder
		RelPath = "<xsl:value-of select="substring-before(/BorlandProject/CSharp.Personality/FileList/File[./@WebReferenceUrl]/@FileName,'\')"/>"
		WebReferences = "TRUE"
	/&gt;
	</xsl:if>

	&lt;/Include&gt;
	&lt;/Files&gt;
</xsl:template>

<!-- This rule strips off the path info -->
<xsl:template name="StripPath">
	<xsl:param name="Module"/>
	<xsl:choose>
	<xsl:when test="contains($Module,'/')">
		<xsl:call-template name="StripPath">
			<xsl:with-param name="Module" select="substring-after($Module, '/')"/>
		</xsl:call-template>
	</xsl:when>
	<xsl:when test="contains($Module,'\')">
		<xsl:call-template name="StripPath">
			<xsl:with-param name="Module" select="substring-after($Module, '\')"/>
		</xsl:call-template>
	</xsl:when>
	<xsl:otherwise>
		<xsl:value-of select="$Module"/>
	</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- References -->
<xsl:template name="References">
	&lt;References&gt;
	<!-- Loop through the borland file list searching for CSAssembly nodes -->
	<xsl:for-each select="/BorlandProject/CSharp.Personality/FileList/File[./@ContainerId='DotNetAssemblyCompiler'] | /BorlandProject/VB.Personality/FileList/File[./@ContainerId='DotNetAssemblyCompiler']">
	<!-- This variable may contain a parent attribute and value or an empty string-->
	<xsl:variable name="Private"><xsl:if test="@CopyLocal">Private = "<xsl:value-of select="@CopyLocal"/>"</xsl:if></xsl:variable>

	&lt;Reference
	<xsl:choose>
	<xsl:when test="@WrapperTool='tlbimp'">
	<xsl:choose>
	<xsl:when test="contains(@FileName,'ComImports\Interop')">
	Name = "<xsl:value-of select="substring-after(@ModuleName,'Interop.')"/>"
	Guid = "<xsl:value-of select="@Guid"/>"
	VersionMajor = "<xsl:value-of select="substring-before(@Version,'.')"/>"
	VersionMinor = "<xsl:value-of select="substring-after(@Version,'.')"/>"
	Lcid = "<xsl:value-of select="@Lcid"/>"
	WrapperTool = "primary"
	<xsl:value-of select="$Private"/>
	</xsl:when>
	<xsl:otherwise>
	Name = "<xsl:value-of select="@ModuleName"/>"
	Guid = "<xsl:value-of select="@Guid"/>"
	VersionMajor = "<xsl:value-of select="substring-before(@Version,'.')"/>"
	VersionMinor = "<xsl:value-of select="substring-after(@Version,'.')"/>"
	Lcid = "<xsl:value-of select="@Lcid"/>"
	WrapperTool = "<xsl:value-of select="@WrapperTool"/>"
	<xsl:value-of select="$Private"/>
	</xsl:otherwise>
	</xsl:choose>
	</xsl:when>
	<xsl:when test="@WrapperTool='aximp'">
	Name = "<xsl:value-of select="substring-after(@ModuleName, 'Interop.')"/>"
	Guid = "<xsl:value-of select="@Guid"/>"
	VersionMajor = "<xsl:value-of select="substring-before(@Version,'.')"/>"
	VersionMinor = "<xsl:value-of select="substring-after(@Version,'.')"/>"
	Lcid = "<xsl:value-of select="@Lcid"/>"
	WrapperTool = "<xsl:value-of select="@WrapperTool"/>"
	<xsl:value-of select="$Private"/>
	</xsl:when>
	<xsl:when test="@Project">
	Name = "<xsl:value-of select="@ModuleName"/>"
	Project = "<xsl:value-of select="@Project"/>"
	Package = ""
	<xsl:value-of select="$Private"/>
	</xsl:when>
	<xsl:otherwise>
	Name = "<xsl:value-of select="@ModuleName"/>"
	AssemblyName = "<xsl:value-of select="@AssemblyName"/>"
	HintPath = "<xsl:value-of select="@FileName"/>"
	<xsl:value-of select="$Private"/>
	</xsl:otherwise>
	</xsl:choose>
	/&gt;
	</xsl:for-each>
	&lt;/References&gt;
</xsl:template>

<!-- ImportData -->
<xsl:template match="ImportData">
	<xsl:apply-templates/>
</xsl:template>

</xsl:stylesheet>
